
/* ************************************************************************ *
 *              Written by Alex de Kruijff                2009              *
 * ************************************************************************ *
 * This source was written with a tabstop every four characters             *
 * In vi type :set ts=4                                                     *
 * ************************************************************************ */

#ifndef AK_STATS_H
#define AK_STATS_H

#include "configure.h"
#include "visitor.h"

#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif // HAVE_LIMITS_H

class Holder;
class SizeGroup;
class FileGroup;
class Filename;

/**
 * Collects stats from the holder graph
 */
class Stats : public SamefileVisitor
{
	size_t minFileSize, maxFileSize, currentFileSize, maxDiskFileSize;
	unsigned long files, filenames; // file : filename = 1 : n
	ulongest_t totalSize;

public:
	Stats() : minFileSize(UINT_MAX), maxFileSize(0), maxDiskFileSize(0),
		files(0), filenames(0), totalSize(0) {}

	/**
	 * Reset the internal values.
	 */
	Stats &reset()
	{
		totalSize = files = filenames = 0;
		maxFileSize = maxDiskFileSize = 0;
		minFileSize = UINT_MAX;
		return *this;
	}

	size_t getMinFileSize() { return minFileSize; }
	size_t getMaxFileSize() { return maxFileSize; }
	size_t getMaxDiskFileSize() { return maxDiskFileSize; }

	unsigned long getFiles() { return files; }
	unsigned long getFilenames() { return filenames; }

	ulongest_t getTotalSize() { return totalSize; }

	int visit(Holder &);
	int visit(SizeGroup &);
	int visit(FileGroup &);
	void visit(Filename &);
};

#endif // AK_STATS_H

