
/* ************************************************************************ *
 * samelink - Read the output from samefile output and links identical      *
 *            files together. The matches that coudn't be processed are     *
 *            printed on the output.                                        *
 *                                                                          *
 * Hard link identical files, keepin the last modified files:               *
 *            find / | samefile -iZt | samelink -Zt                         *
 *                                                                          *
 * Create symlinks to between files that are not on the same filesystem     *
 *            find / | samefile -i | samelink -s                            *
 * ************************************************************************ * 
 *              Written by Alex de Kruijff                2009              *
 * ************************************************************************ * 
 * This source was written with a tabstop every four characters             * 
 * In vi type :set ts=4                                                     * 
 * ************************************************************************ */

#include "mainAction.h"

/**
 * Prints the line again.
 */
int echo(const char *left, const char *right,
	const struct stat &s1, const struct stat &s2,
	const char *dst, const char *src, char *backup)
{
	return PRINT_AGAIN;
}

int main(int argc, char **argv)
{
	actionProcessOptions(argc, argv, "echo");
	actionProcessInput(echo);
	if (S_VERBOSE_LEVEL3(flags))
		actionProcessStats();
}

