
#ifndef AK_CONFIGURE_H
#define AK_CONFIGURE_H

// #define WITH_DISK_STORAGE
// #define DEBUG
// #define LOW_MEMORY_PROFILE

/* If READ_ONLY_ONCES is defined the code will read each file only ones.
 * If READ_ONLY_ONCES is not defined the code will use less memory.
 */
#ifndef LOW_MEMORY_PROFILE
#define READ_ONLY_ONCES
#endif // LOW_MEMORY_PROFILE

#ifndef TEMP_STORAGE_DIR
#define TEMP_STORAGE_DIR	"/tmp/"
#endif
#ifndef PATH_INIT
#define PATH_INIT		256
#endif
#ifndef STATIC_CACHE_CAPACITY
#define STATIC_CACHE_CAPACITY	8192
#endif
#ifndef EXPECTED_MAX_GROUP
#define EXPECTED_MAX_GROUP 2048
#endif // EXPECTED_MAX_GROUP

#define USE_MMAP(m)		((m) < 8 * 1048576)

#define COPYRIGHT		"%s, %s, copyright (c) 2009 Alex de Kruijff\n"

#ifdef __LONG_LONG_SUPPORTED
typedef long long longest_t;
typedef unsigned long long ulongest_t;
#else // __LONG_LONG_SUPPORTED
typedef long longest_t;
typedef unsigned long ulongest_t;
#endif // __LONG_LONG_SUPPORTED

#ifdef HAVE_CONFIG_H
#include "../config.h"
#else // HAVE_CONFIG_H

#define PACKAGE "samesame"
#define PACKAGE_BUGREPORT "samesame@akruijff.dds.nl"
#define PACKAGE_NAME "SameSame"
#define PACKAGE_STRING "SameSame 1.7"
#define PACKAGE_TARNAME "samesame"
#define PACKAGE_VERSION "1.7"
#define VERSION "1.7"

#endif // HAVE_CONFIG_H

// #undef HAVE_FCNTL_H
// #undef HAVE_GETPAGESIZE
// #undef HAVE_GETTIMEOFDAY
// #undef HAVE_INTTYPES_H
// #undef HAVE_LIMITS_H
// #undef HAVE_LOCALECONV
// #undef HAVE_LOCALE_H
// #undef HAVE_LSTAT_EMPTY_STRING_BUG
// #undef HAVE_MALLOC
// #undef HAVE_MEMORY_H
// #undef HAVE_MEMSET
// #undef HAVE_MKDIR
// #undef HAVE_MMAP
// #undef HAVE_MUNMAP
// #undef HAVE_RMDIR
// #define HAVE_STAT_EMPTY_STRING_BUG 1 
// #undef HAVE_STDDEF_H
// #undef HAVE_STDINT_H
// #undef HAVE_STDLIB_H
// #undef HAVE_STRINGS_H
// #undef HAVE_STRING_H
// #undef HAVE_STRSTR
// #undef HAVE_SYS_STAT_H
// #undef HAVE_SYS_TIME_H
// #undef HAVE_SYS_TYPES_H
// #undef HAVE_UNISTD_H
// #define LSTAT_FOLLOWS_SLASHED_SYMLINK 1

#endif // AK_CONFIGURE_H

